/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.google.common.util.concurrent.Runnables;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.mojang.math.Vector3f;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.screens.RealmsNotificationsScreen;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.AccessibilityOptionsScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.LanguageSelectScreen;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.Realms32bitWarningScreen;
import net.minecraft.client.gui.screens.multiplayer.SafetyScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.gui.ModListScreen;
import net.minecraftforge.client.gui.NotificationModUpdateScreen;
import net.minecraftforge.internal.BrandingControl;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class TitleScreen
extends Screen {
    private static final Logger f_96717_ = LogUtils.getLogger();
    private static final String f_169439_ = "Demo_World";
    public static final Component f_169438_ = new TextComponent("Copyright Mojang AB. Do not distribute!");
    public static final CubeMap f_96716_ = new CubeMap(new ResourceLocation("textures/gui/title/background/panorama"));
    private static final ResourceLocation f_96718_ = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private static final ResourceLocation f_96719_ = new ResourceLocation("textures/gui/accessibility.png");
    private final boolean f_96720_;
    @Nullable
    private String f_96721_;
    private Button f_96722_;
    private static final ResourceLocation f_96723_ = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation f_96724_ = new ResourceLocation("textures/gui/title/edition.png");
    private Screen f_96726_;
    private final PanoramaRenderer f_96729_ = new PanoramaRenderer(f_96716_);
    private final boolean f_96714_;
    private long f_96715_;
    @Nullable
    private Warning32Bit f_210857_;
    private RealmsClient f_210858_;
    private boolean f_210859_ = false;
    private NotificationModUpdateScreen modUpdateNotification;

    public TitleScreen() {
        this(false);
    }

    public TitleScreen(boolean p_96733_) {
        super((Component)((Object)new TranslatableComponent("narrator.screen.title")));
        this.f_96714_ = p_96733_;
        this.f_96720_ = (double)new Random().nextFloat() < 1.0E-4;
        this.f_210858_ = RealmsClient.m_87169_();
    }

    private boolean m_96789_() {
        return this.f_96541_.f_91066_.f_92046_ && this.f_96726_ != null;
    }

    @Override
    public void m_96624_() {
        if (this.m_96789_()) {
            this.f_96726_.m_96624_();
        }
        this.m_210873_();
    }

    private void m_210873_() {
        try {
            if (this.f_210857_ != null && !this.f_96541_.f_91066_.f_210816_ && !this.f_210859_ && this.f_210857_.f_210878_.getNow(false).booleanValue()) {
                this.f_210859_ = true;
                this.f_96541_.m_91152_((Screen)new Realms32bitWarningScreen((Screen)this));
            }
        }
        catch (CompletionException completionexception) {
            f_96717_.warn("Failed to retrieve realms subscriptions", (Throwable)completionexception);
            this.f_210859_ = true;
        }
    }

    public static CompletableFuture<Void> m_96754_(TextureManager p_96755_, Executor p_96756_) {
        return CompletableFuture.allOf(p_96755_.m_118501_(f_96723_, p_96756_), p_96755_.m_118501_(f_96724_, p_96756_), p_96755_.m_118501_(f_96718_, p_96756_), f_96716_.m_108854_(p_96755_, p_96756_));
    }

    @Override
    public boolean m_7043_() {
        return false;
    }

    @Override
    public boolean m_6913_() {
        return false;
    }

    @Override
    protected void m_7856_() {
        if (this.f_96721_ == null) {
            this.f_96721_ = this.f_96541_.m_91310_().m_118867_();
        }
        int i = this.f_96547_.m_92852_((FormattedText)f_169438_);
        int j = this.f_96543_ - i - 2;
        int k = 24;
        int l = this.f_96544_ / 4 + 48;
        Button modButton = null;
        if (this.f_96541_.m_91402_()) {
            this.m_96772_(l, 24);
        } else {
            this.m_96763_(l, 24);
            modButton = this.m_142416_(new Button(this.f_96543_ / 2 - 100, l + 48, 98, 20, (Component)((Object)new TranslatableComponent("fml.menu.mods")), p_96791_ -> this.f_96541_.m_91152_((Screen)new ModListScreen((Screen)this))));
        }
        this.modUpdateNotification = NotificationModUpdateScreen.init((TitleScreen)this, modButton);
        this.m_142416_(new ImageButton(this.f_96543_ / 2 - 124, l + 72 + 12, 20, 20, 0, 106, 20, Button.f_93617_, 256, 256, p_96788_ -> this.f_96541_.m_91152_((Screen)new LanguageSelectScreen((Screen)this, this.f_96541_.f_91066_, this.f_96541_.m_91102_())), (Component)((Object)new TranslatableComponent("narrator.button.language"))));
        this.m_142416_(new Button(this.f_96543_ / 2 - 100, l + 72 + 12, 98, 20, (Component)((Object)new TranslatableComponent("menu.options")), p_96786_ -> this.f_96541_.m_91152_(new OptionsScreen(this, this.f_96541_.f_91066_))));
        this.m_142416_(new Button(this.f_96543_ / 2 + 2, l + 72 + 12, 98, 20, (Component)((Object)new TranslatableComponent("menu.quit")), p_96784_ -> this.f_96541_.m_91395_()));
        this.m_142416_(new ImageButton(this.f_96543_ / 2 + 104, l + 72 + 12, 20, 20, 0, 0, 20, f_96719_, 32, 64, p_211790_ -> this.f_96541_.m_91152_((Screen)new AccessibilityOptionsScreen((Screen)this, this.f_96541_.f_91066_)), (Component)((Object)new TranslatableComponent("narrator.button.accessibility"))));
        this.m_142416_(new PlainTextButton(j, this.f_96544_ - 10, i, 10, f_169438_, p_211790_ -> this.f_96541_.m_91152_((Screen)new WinScreen(false, Runnables.doNothing())), this.f_96547_));
        this.f_96541_.m_91372_(false);
        if (this.f_96541_.f_91066_.f_92046_ && this.f_96726_ == null) {
            this.f_96726_ = new RealmsNotificationsScreen();
        }
        if (this.m_96789_()) {
            this.f_96726_.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
        if (!this.f_96541_.m_91103_()) {
            CompletableFuture<Boolean> completablefuture = this.f_210857_ != null ? this.f_210857_.f_210878_ : CompletableFuture.supplyAsync(this::m_210874_, Util.m_183991_());
            this.f_210857_ = new Warning32Bit(MultiLineLabel.m_94345_((Font)this.f_96547_, (FormattedText)new TranslatableComponent("title.32bit.deprecation"), (int)350, (int)2), this.f_96543_ / 2, l - 24, completablefuture);
        }
    }

    private boolean m_210874_() {
        try {
            return this.f_210858_.m_87235_().f_87573_.stream().anyMatch(p_211781_ -> p_211781_.f_87479_ != null && !p_211781_.f_87482_ && p_211781_.f_87479_.equals(this.f_96541_.m_91094_().m_92545_()));
        }
        catch (RealmsServiceException realmsserviceexception) {
            return false;
        }
    }

    private void m_96763_(int p_96764_, int p_96765_) {
        this.m_142416_(new Button(this.f_96543_ / 2 - 100, p_96764_, 200, 20, (Component)((Object)new TranslatableComponent("menu.singleplayer")), p_210872_ -> this.f_96541_.m_91152_((Screen)new SelectWorldScreen((Screen)this))));
        boolean flag = this.f_96541_.m_91400_();
        Button.OnTooltip button$ontooltip = flag ? Button.f_93716_ : new Button.OnTooltip(){
            private final Component f_169452_ = new TranslatableComponent("title.multiplayer.disabled");

            public void m_93752_(Button p_169458_, PoseStack p_169459_, int p_169460_, int p_169461_) {
                if (!p_169458_.f_93623_) {
                    TitleScreen.this.m_96617_(p_169459_, TitleScreen.this.f_96541_.f_91062_.m_92923_((FormattedText)this.f_169452_, Math.max(TitleScreen.this.f_96543_ / 2 - 43, 170)), p_169460_, p_169461_);
                }
            }

            public void m_142753_(Consumer<Component> p_169456_) {
                p_169456_.accept(this.f_169452_);
            }
        };
        this.m_142416_(new Button((int)(this.f_96543_ / 2 - 100), (int)(p_96764_ + p_96765_ * 1), (int)200, (int)20, (Component)((Object)new TranslatableComponent((String)"menu.multiplayer")), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, m_211787_(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((TitleScreen)this), (Button.OnTooltip)button$ontooltip)).f_93623_ = flag;
        this.m_142416_(new Button((int)(this.f_96543_ / 2 + 2), (int)(p_96764_ + p_96765_ * 2), (int)98, (int)20, (Component)((Object)new TranslatableComponent((String)"menu.online")), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$createNormalMenuOptions$9(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((TitleScreen)this), (Button.OnTooltip)button$ontooltip)).f_93623_ = flag;
    }

    private void m_96772_(int p_96773_, int p_96774_) {
        boolean flag = this.m_96792_();
        this.m_142416_(new Button(this.f_96543_ / 2 - 100, p_96773_, 200, 20, (Component)((Object)new TranslatableComponent("menu.playdemo")), p_211786_ -> {
            if (flag) {
                this.f_96541_.m_91200_(f_169439_);
            } else {
                RegistryAccess registryaccess = RegistryAccess.f_123049_.get();
                this.f_96541_.m_205185_(f_169439_, MinecraftServer.f_129743_, registryaccess, WorldGenSettings.m_64645_(registryaccess));
            }
        }));
        this.f_96722_ = this.m_142416_(new Button(this.f_96543_ / 2 - 100, p_96773_ + p_96774_ * 1, 200, 20, (Component)((Object)new TranslatableComponent("menu.resetdemo")), p_211783_ -> {
            LevelStorageSource levelstoragesource = this.f_96541_.m_91392_();
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = levelstoragesource.m_78260_(f_169439_);){
                LevelSummary levelsummary = levelstoragesource$levelstorageaccess.m_78308_();
                if (levelsummary != null) {
                    this.f_96541_.m_91152_((Screen)new ConfirmScreen(this::m_96777_, (Component)((Object)new TranslatableComponent("selectWorld.deleteQuestion")), (Component)((Object)new TranslatableComponent("selectWorld.deleteWarning", levelsummary.m_78361_())), (Component)((Object)new TranslatableComponent("selectWorld.deleteButton")), CommonComponents.f_130656_));
                }
            }
            catch (IOException ioexception) {
                SystemToast.m_94852_((Minecraft)this.f_96541_, (String)f_169439_);
                f_96717_.warn("Failed to access demo world", (Throwable)ioexception);
            }
        }));
        this.f_96722_.f_93623_ = flag;
    }

    private boolean m_96792_() {
        try {
            boolean flag;
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.f_96541_.m_91392_().m_78260_(f_169439_);){
                flag = levelstoragesource$levelstorageaccess.m_78308_() != null;
            }
            return flag;
        }
        catch (IOException ioexception) {
            SystemToast.m_94852_((Minecraft)this.f_96541_, (String)f_169439_);
            f_96717_.warn("Failed to read demo world data", (Throwable)ioexception);
            return false;
        }
    }

    private void m_96793_() {
        this.f_96541_.m_91152_((Screen)new RealmsMainScreen((Screen)this));
    }

    @Override
    public void m_6305_(PoseStack p_96739_, int p_96740_, int p_96741_, float p_96742_) {
        if (this.f_96715_ == 0L && this.f_96714_) {
            this.f_96715_ = Util.m_137550_();
        }
        float f = this.f_96714_ ? (float)(Util.m_137550_() - this.f_96715_) / 1000.0f : 1.0f;
        this.f_96729_.m_110003_(p_96742_, Mth.m_14036_((float)f, (float)0.0f, (float)1.0f));
        int i = 274;
        int j = this.f_96543_ / 2 - 137;
        int k = 30;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_96718_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.f_96714_ ? (float)Mth.m_14167_((float)Mth.m_14036_((float)f, (float)0.0f, (float)1.0f)) : 1.0f));
        TitleScreen.m_93160_((PoseStack)p_96739_, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (float)0.0f, (float)0.0f, (int)16, (int)128, (int)16, (int)128);
        float f1 = this.f_96714_ ? Mth.m_14036_((float)(f - 1.0f), (float)0.0f, (float)1.0f) : 1.0f;
        int l = Mth.m_14167_((float)(f1 * 255.0f)) << 24;
        if ((l & 0xFC000000) != 0) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)f_96723_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)f1);
            if (this.f_96720_) {
                this.m_93101_(j, 30, (p_211778_, p_211779_) -> {
                    this.m_93228_(p_96739_, p_211778_ + 0, (int)p_211779_, 0, 0, 99, 44);
                    this.m_93228_(p_96739_, p_211778_ + 99, (int)p_211779_, 129, 0, 27, 44);
                    this.m_93228_(p_96739_, p_211778_ + 99 + 26, (int)p_211779_, 126, 0, 3, 44);
                    this.m_93228_(p_96739_, p_211778_ + 99 + 26 + 3, (int)p_211779_, 99, 0, 26, 44);
                    this.m_93228_(p_96739_, p_211778_ + 155, (int)p_211779_, 0, 45, 155, 44);
                });
            } else {
                this.m_93101_(j, 30, (p_211778_, p_211779_) -> {
                    this.m_93228_(p_96739_, p_211778_ + 0, (int)p_211779_, 0, 0, 155, 44);
                    this.m_93228_(p_96739_, p_211778_ + 155, (int)p_211779_, 0, 45, 155, 44);
                });
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)f_96724_);
            TitleScreen.m_93133_((PoseStack)p_96739_, (int)(j + 88), (int)67, (float)0.0f, (float)0.0f, (int)98, (int)14, (int)128, (int)16);
            if (this.f_210857_ != null) {
                this.f_210857_.f_210875_.m_207298_(p_96739_, this.f_210857_.f_210876_, this.f_210857_.f_210877_, 9, 2, 0x55200000);
                this.f_210857_.f_210875_.m_6514_(p_96739_, this.f_210857_.f_210876_, this.f_210857_.f_210877_, 9, 0xFFFFFF | l);
            }
            ForgeHooksClient.renderMainMenu((TitleScreen)this, (PoseStack)p_96739_, (Font)this.f_96547_, (int)this.f_96543_, (int)this.f_96544_, (int)l);
            if (this.f_96721_ != null) {
                p_96739_.m_85836_();
                p_96739_.m_85837_((double)(this.f_96543_ / 2 + 90), 70.0, 0.0);
                p_96739_.m_85845_(Vector3f.f_122227_.m_122240_(-20.0f));
                float f2 = 1.8f - Mth.m_14154_((float)(Mth.m_14031_((float)((float)(Util.m_137550_() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
                f2 = f2 * 100.0f / (float)(this.f_96547_.m_92895_(this.f_96721_) + 32);
                p_96739_.m_85841_(f2, f2, f2);
                TitleScreen.m_93208_((PoseStack)p_96739_, (Font)this.f_96547_, (String)this.f_96721_, (int)0, (int)-8, (int)(0xFFFF00 | l));
                p_96739_.m_85849_();
            }
            String s = "Minecraft " + SharedConstants.m_183709_().getName();
            s = this.f_96541_.m_91402_() ? s + " Demo" : s + (String)("release".equalsIgnoreCase(this.f_96541_.m_91389_()) ? "" : "/" + this.f_96541_.m_91389_());
            if (Minecraft.m_193589_().m_184597_()) {
                s = s + I18n.m_118938_("menu.modded", new Object[0]);
            }
            BrandingControl.forEachLine((boolean)true, (boolean)true, (brdline, brd) -> {
                int n = brdline;
                Objects.requireNonNull(this.f_96547_);
                TitleScreen.m_93236_((PoseStack)p_96739_, (Font)this.f_96547_, (String)brd, (int)2, (int)(this.f_96544_ - (10 + n * (9 + 1))), (int)(0xFFFFFF | l));
            });
            BrandingControl.forEachAboveCopyrightLine((brdline, brd) -> {
                int n = this.f_96543_ - this.f_96547_.m_92895_(brd);
                int n2 = brdline + 1;
                Objects.requireNonNull(this.f_96547_);
                TitleScreen.m_93236_((PoseStack)p_96739_, (Font)this.f_96547_, (String)brd, (int)n, (int)(this.f_96544_ - (10 + n2 * (9 + 1))), (int)(0xFFFFFF | l));
            });
            for (GuiEventListener guiEventListener : this.m_6702_()) {
                if (!(guiEventListener instanceof AbstractWidget)) continue;
                ((AbstractWidget)guiEventListener).m_93650_(f1);
            }
            super.m_6305_(p_96739_, p_96740_, p_96741_, p_96742_);
            if (this.m_96789_() && f1 >= 1.0f) {
                this.f_96726_.m_6305_(p_96739_, p_96740_, p_96741_, p_96742_);
            }
            if (f1 >= 1.0f) {
                this.modUpdateNotification.m_6305_(p_96739_, p_96740_, p_96741_, p_96742_);
            }
        }
    }

    public boolean m_6375_(double p_96735_, double p_96736_, int p_96737_) {
        if (super.m_6375_(p_96735_, p_96736_, p_96737_)) {
            return true;
        }
        return this.m_96789_() && this.f_96726_.m_6375_(p_96735_, p_96736_, p_96737_);
    }

    @Override
    public void m_7861_() {
        if (this.f_96726_ != null) {
            this.f_96726_.m_7861_();
        }
    }

    private void m_96777_(boolean p_96778_) {
        if (p_96778_) {
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.f_96541_.m_91392_().m_78260_(f_169439_);){
                levelstoragesource$levelstorageaccess.m_78311_();
            }
            catch (IOException ioexception) {
                SystemToast.m_94866_((Minecraft)this.f_96541_, (String)f_169439_);
                f_96717_.warn("Failed to delete demo world", (Throwable)ioexception);
            }
        }
        this.f_96541_.m_91152_(this);
    }

    private /* synthetic */ void lambda$createNormalMenuOptions$9(Button p_96771_) {
        this.m_96793_();
    }

    private /* synthetic */ void m_211787_(Button p_211788_) {
        JoinMultiplayerScreen screen = this.f_96541_.f_91066_.f_92083_ ? new JoinMultiplayerScreen(this) : new SafetyScreen((Screen)this);
        this.f_96541_.m_91152_(screen);
    }

    @OnlyIn(value=Dist.CLIENT)
    record Warning32Bit(MultiLineLabel f_210875_, int f_210876_, int f_210877_, CompletableFuture<Boolean> f_210878_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Warning32Bit.class, "label;x;y;realmsSubscriptionFuture", "f_210875_", "f_210876_", "f_210877_", "f_210878_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Warning32Bit.class, "label;x;y;realmsSubscriptionFuture", "f_210875_", "f_210876_", "f_210877_", "f_210878_"}, this);
        }

        @Override
        public final boolean equals(Object p_210889_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Warning32Bit.class, "label;x;y;realmsSubscriptionFuture", "f_210875_", "f_210876_", "f_210877_", "f_210878_"}, this, p_210889_);
        }
    }
}

